/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rptprob;

import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.base.rptprob.ReportProblemBean;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFactory;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.ui.framework.TaskActionEvent;
import java.beans.PropertyVetoException;

public class ReportProblemTasklet
extends TargetedTasklet {
    private static final String TRACE_MASKT = "HRPPTSKT";
    private static final String TRACE_MASKF = "HRPPTSKF";
    private static final String TRACE_MASKD = "HRPPTSKD";
    private PresentationTaskParms myPTP;
    private ObjectId[] locTargets;
    private UserContext uContext;
    private boolean isVPD = false;

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> service: ");
        if (request.isInitialRequest()) {
            this.myPTP = this.getPresentationTaskParms();
            this.uContext = this.myPTP.getUserContext();
            this.locTargets = this.myPTP.getTargetIds();
            ReportProblemBean databean = new ReportProblemBean();
            response.replace("com.ibm.hwmca.base.rptprob.res.ReportProblemRes", "ReportProblemPanel", databean);
        } else if (request.isDisposed()) {
            response.terminate();
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("event");
            String eventname = event == null ? (String)request.getData("menuevent") : event.getElementName();
            if (eventname.equals("RequestServiceButton")) {
                try {
                    Trace.trace(TRACE_MASKT, "Sending problem");
                    String description = (String)request.getData("desc");
                    ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
                    ConsoleSystem consoleSystem = cad.getConsoleSystem();
                    ProblemFactory pf = (ProblemFactory)ServiceInterfaces.getFactory(consoleSystem, "ProblemFactory");
                    Boolean isAuto = (Boolean)request.getData("auto");
                    Problem problem = null;
                    problem = isAuto != false ? pf.createProblem(consoleSystem, "DumpProblem") : pf.createProblem(consoleSystem, "ConsoleProblem");
                    if (problem instanceof CommonProblem) {
                        ((CommonProblem)problem).setManuallyInitiated(true);
                    }
                    if (problem instanceof CommonProblem) {
                        ((CommonProblem)problem).setCustomerDescription(description);
                    }
                    ProblemManager problemManager = ProblemManager.getProblemManager();
                    problemManager.open(problem);
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), "reptprob.general.title"), new BaseMessageText("XPA7020"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKT, hexc);
                }
                catch (PropertyVetoException pvexc) {
                    Trace.trace(TRACE_MASKT, pvexc);
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKT, exc);
                }
            }
            Trace.trace(TRACE_MASKT, "<< service: ");
            response.noAction();
        }
    }
}

